<?= $this->include('layout/header_admin') ?>

<h3 class="mb-4" style="color: white;">📋 Data Biodata</h3>

<div class="row mb-3">
    <div class="col-md-6">
        <form method="get" class="d-flex">
            <input type="text" name="keyword" class="form-control me-2"
                placeholder="Cari nama / email"
                value="<?= $_GET['keyword'] ?? '' ?>">
            <button class="btn btn-primary">Cari</button>
        </form>
    </div>

    <div class="col-md-6 text-end">
        <a href="biodata/create" class="btn btn-success">
            ➕ Tambah Biodata
        </a>
    </div>
</div>

<div class="row">

    <?php if (empty($biodata)): ?>
        <div class="col-12">
            <div class="alert alert-warning text-center">
                Data biodata belum tersedia
            </div>
        </div>
    <?php endif; ?>

    <?php foreach ($biodata as $b): ?>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="card shadow-sm h-100">

                <!-- FOTO -->
                <div class="text-center mt-3">
                    <?php if (!empty($b['foto'])): ?>
                        <img src="<?= base_url('uploads/biodata/' . $b['foto']) ?>"
                            class="rounded-circle img-thumbnail"
                            width="120" height="120">
                    <?php else: ?>
                        <img src="https://via.placeholder.com/120"
                            class="rounded-circle img-thumbnail">
                    <?php endif; ?>
                </div>

                <!-- BIODATA -->
                <div class="card-body">
                    <h5 class="text-center mb-3"><?= esc($b['nama']) ?></h5>

                    <p class="mb-1"><strong>NIM:</strong> <?= esc($b['nim']) ?></p>
                    <p class="mb-1"><strong>Jenis Kelamin:</strong> <?= esc($b['jenis_kelamin']) ?></p>
                    <p class="mb-1">
                        <strong>TTL:</strong>
                        <?= esc($b['tempat_lahir']) ?>,
                        <?= esc($b['tanggal_lahir']) ?>
                    </p>
                    <p class="mb-1"><strong>Alamat:</strong> <?= esc($b['alamat']) ?></p>
                    <p class="mb-1"><strong>No HP:</strong> <?= esc($b['no_hp']) ?></p>
                    <p class="mb-1"><strong>Email:</strong> <?= esc($b['email']) ?></p>
                </div>

                <!-- AKSI -->
                <div class="card-footer text-center bg-white">
                    <a href="biodata/edit/<?= $b['id'] ?>"
                        class="btn btn-warning btn-sm">
                        ✏ Edit
                    </a>

                    <a href="biodata/delete/<?= $b['id'] ?>"
                        class="btn btn-danger btn-sm"
                        onclick="return confirm('Yakin hapus data?')">
                        🗑 Hapus
                    </a>
                </div>

            </div>
        </div>
    <?php endforeach; ?>

</div>

<!-- PAGINATION -->
<div class="d-flex justify-content-center mt-4">
    <?= $pager->links('default', 'bootstrap_full') ?>
</div>

<?= $this->include('layout/footer_admin') ?>